/*
 * A super-simple database system
 * Internal definitions
 */

#include <errno.h>

/*
 * A database handle
 */
struct db_database {
  char *db_dir;		/* directory this database resides in */
  int open_tables;	/* tables should be closed before closing database */
  int writeable;	/* true if opened in write mode */
};


/*
 * A DB table
 */
struct db_table {
  struct db_database *db;	/* associated database */
  char *full_name;		/* name of file associated with the table */
  char *new_name;		/* place where new data will be written */
  char *old_name;		/* where old file will be renamed to */

  int ncols;			/* number of columns */
  char **col_names;		/* name of each column */
  db_datum_type_t *col_types;	/* type of each column */

  int nrows;			/* rows in use */
  int alloc_rows;		/* row pointers allocated */
  db_datum_t **rows;		/* the data in the table */

  int dirty;			/* true if table has changed */
};

/*
 * misc definitions
 */
#define DB_MAX_COLS 128		/* maximum number of columns */
#define DB_MAX_LINE 10240	/* max line length */

#define DB_ROW_ALLOC_INCR 1024	/* increment size for table row array */

/* table filename extensions */
#define DB_TBLEXT_PRIMARY "csv"
#define DB_TBLEXT_NEW "csv.new"
#define DB_TBLEXT_OLD "csv.old"

/*
 * Error habdling
 */
extern int errno;
#define DB_ERROR(ERRNO) do { dberrno = ERRNO; goto except; } while (0)


